<?php
namespace VM\ApiBundle\DataFixtures\ORM;

use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use VM\ApiBundle\Entity\DistributionSales;
use VM\ApiBundle\Entity\MarketSegment;

class LoadDistributionSales extends AbstractFixture implements OrderedFixtureInterface, ContainerAwareInterface
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @var \Doctrine\ORM\EntityManager
     */
    private $EntityManager;


    protected $distributionSales = array(
        array(
            'marketSegmentSymbol'=>'BOOKS',
            'distributions'=>array(
                array('name'=>'sieć empik','discount'=>55,'efficiency'=>array('PIR'=>'10')),
                array('name'=>'kioski w urzędach skarbowych','discount'=>45,'efficiency'=>array('PIR'=>'10')),
                array('name'=>'księgarnie prawno-finansowe','discount'=>40,'efficiency'=>array()),
                array('name'=>'księgarnie akademickie','discount'=>35,'efficiency'=>array('PIR'=>'10|5|2')),
                array('name'=>'księgarnie on-line','discount'=>25,'efficiency'=>array()),
                array('name'=>'inne księgarnie','discount'=>30,'efficiency'=>array()),
                array('name'=>'sprzedaż detaliczna','discount'=>0,'efficiency'=>array()),
            )
        )
    );

    /**
     * {@inheritDoc}
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }

    /**
     * @param ObjectManager $EntityManager
     */
    public function load(ObjectManager $EntityManager)
    {
        $this->EntityManager = $EntityManager;

        foreach($this->distributionSales as $distributionSales)
        {
            $MarketSegment = $this->getMarketSegment($distributionSales['marketSegmentSymbol']);
            foreach($distributionSales['distributions'] as $distribution)
            {
                $DistributionSales = new DistributionSales();
                $DistributionSales->setName($distribution['name']);
                $DistributionSales->setDiscount($distribution['discount']);
                $DistributionSales->setEfficiency(json_encode($distribution['efficiency']));
                $DistributionSales->setMarketSegment($MarketSegment);

                $this->EntityManager->persist($DistributionSales);
            }
        }

        $this->EntityManager->flush();
    }

    /**
     * @param $symbol
     * @return MarketSegment
     */
    private function getMarketSegment($symbol)
    {
        return $this->EntityManager->getRepository('VMApiBundle:MarketSegment')->findOneBy(array('symbol'=>$symbol));
    }

    public function getOrder()
    {
        return 3000;
    }
}